<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Providers\RouteServiceProvider;
use Illuminate\Auth\Events\Verified;
use Illuminate\Foundation\Auth\EmailVerificationRequest;
use App\Models\User;

class VerifyEmailController extends Controller
{
    /**
     * Mark the authenticated user's email address as verified.
     *
     * @param  \Illuminate\Foundation\Auth\EmailVerificationRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function __invoke(EmailVerificationRequest $request)
    {
        if ($request->user()->hasVerifiedEmail()) {
            return redirect()->intended(RouteServiceProvider::HOME.'?verified=1')->with('verified', true);
        }

        
        if ($request->user()->markEmailAsVerified()) {
            event(new Verified($request->user()));

            $user = User::find(auth()->user()->id);
            $user->status = 'active';
            $user->save();
        }

        return redirect()->intended(RouteServiceProvider::HOME.'?verified=1')->with('success', 'Congratulations! Your account is fully active now');
    }

}
